/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.murmelapi.group.permission;

import de.murmelmeister.murmelapi.group.Group;
import de.murmelmeister.murmelapi.group.parent.GroupParent;
import de.murmelmeister.murmelapi.group.permission.GroupPermission;
import de.murmelmeister.murmelapi.utils.Database;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public final class GroupPermissionProvider
implements GroupPermission {
    private static final String TABLE_NAME = "GroupPermission";

    public GroupPermissionProvider() {
        this.createTable();
        Procedure.loadAll();
    }

    private void createTable() {
        Database.update("CREATE TABLE IF NOT EXISTS %s (GroupID INT, CreatorID INT, Permission VARCHAR(1000), CreatedTime BIGINT(255), ExpiredTime BIGINT(255))", TABLE_NAME);
    }

    @Override
    public boolean existsPermission(int groupId, String permission) {
        return Database.exists("CALL %s('%s','%s')", Procedure.PROCEDURE_PERMISSION.getName(), groupId, permission);
    }

    @Override
    public void addPermission(int groupId, int creatorId, String permission, long time) {
        if (this.existsPermission(groupId, permission)) {
            return;
        }
        long expired = time == -1L ? time : System.currentTimeMillis() + time;
        Database.update("CALL %s('%s','%s','%s','%s','%s')", Procedure.PROCEDURE_ADD.getName(), groupId, creatorId, permission, System.currentTimeMillis(), expired);
    }

    @Override
    public void removePermission(int groupId, String permission) {
        Database.update("CALL %s('%s','%s')", Procedure.PROCEDURE_REMOVE.getName(), groupId, permission);
    }

    @Override
    public void clearPermission(int groupId) {
        Database.update("CALL %s('%s')", Procedure.PROCEDURE_CLEAR.getName(), groupId);
    }

    @Override
    public List<String> getPermissions(int groupId) {
        return Database.getStringList("Permission", "CALL %s('%s')", Procedure.PROCEDURE_GROUP_ID.getName(), groupId);
    }

    @Override
    public List<String> getAllPermissions(GroupParent groupParent, int groupId) {
        Set<String> permissions = Collections.synchronizedSet(new LinkedHashSet<String>(this.getPermissions(groupId)));
        groupParent.getParentIds(groupId).parallelStream().map(parentId -> this.getAllPermissions(groupParent, (int)parentId)).forEach(permissions::addAll);
        return new ArrayList<String>(permissions);
    }

    @Override
    public int getCreatorId(int groupId, String permission) {
        return Database.getInt(-2, "CreatorID", "CALL %s('%s','%s')", Procedure.PROCEDURE_PERMISSION.getName(), groupId, permission);
    }

    @Override
    public long getCreatedTime(int groupId, String permission) {
        return Database.getLong(-1L, "CreatedTime", "CALL %s('%s','%s')", Procedure.PROCEDURE_PERMISSION.getName(), groupId, permission);
    }

    @Override
    public String getCreatedDate(int groupId, String permission) {
        return new SimpleDateFormat("dd.MM.yyyy HH:mm:ss").format(this.getCreatedTime(groupId, permission));
    }

    @Override
    public long getExpiredTime(int groupId, String permission) {
        return Database.getLong(-2L, "ExpiredTime", "CALL %s('%s','%s')", Procedure.PROCEDURE_PERMISSION.getName(), groupId, permission);
    }

    @Override
    public String getExpiredDate(int groupId, String permission) {
        long time = this.getExpiredTime(groupId, permission);
        return time == -1L ? "never" : new SimpleDateFormat("dd.MM.yyyy HH:mm:ss").format(time);
    }

    @Override
    public String setExpiredTime(int groupId, String permission, long time) {
        long expired = time == -1L ? time : System.currentTimeMillis() + time;
        Database.update("CALL %s('%s','%s','%s')", Procedure.PROCEDURE_EXPIRED.getName(), groupId, permission, expired);
        return this.getExpiredDate(groupId, permission);
    }

    @Override
    public String addExpiredTime(int groupId, String permission, long time) {
        long current = this.getExpiredTime(groupId, permission);
        long expired = current == -1L ? System.currentTimeMillis() + time : current + time;
        Database.update("CALL %s('%s','%s','%s')", Procedure.PROCEDURE_EXPIRED.getName(), groupId, permission, expired);
        return this.getExpiredDate(groupId, permission);
    }

    @Override
    public String removeExpiredTime(int groupId, String permission, long time) {
        long current = this.getExpiredTime(groupId, permission);
        long expired = current == -1L ? System.currentTimeMillis() : current - time;
        Database.update("CALL %s('%s','%s','%s')", Procedure.PROCEDURE_EXPIRED.getName(), groupId, permission, expired);
        return this.getExpiredDate(groupId, permission);
    }

    @Override
    public void loadExpired(Group group) {
        for (Integer groupId : group.getUniqueIds()) {
            for (String permission : this.getPermissions(groupId)) {
                long time = this.getExpiredTime(groupId, permission);
                if (time == -1L || time > System.currentTimeMillis()) continue;
                this.removePermission(groupId, permission);
            }
        }
    }

    private static enum Procedure {
        PROCEDURE_GROUP_ID("GroupPermission_GroupID", Database.getProcedureQuery("GroupPermission_GroupID", "gid INT", "SELECT * FROM %s WHERE GroupID=gid;", "GroupPermission")),
        PROCEDURE_PERMISSION("GroupPermission_Permission", Database.getProcedureQuery("GroupPermission_Permission", "gid INT, perm VARCHAR(1000)", "SELECT * FROM %s WHERE GroupID=gid AND Permission=perm;", "GroupPermission")),
        PROCEDURE_ADD("GroupPermission_Add", Database.getProcedureQuery("GroupPermission_Add", "gid INT, creator INT, perm VARCHAR(1000), created BIGINT(255), expired BIGINT(255)", "INSERT INTO %s VALUES (gid, creator, perm, created, expired);", "GroupPermission")),
        PROCEDURE_REMOVE("GroupPermission_Remove", Database.getProcedureQuery("GroupPermission_Remove", "gid INT, perm VARCHAR(1000)", "DELETE FROM %s WHERE GroupID=gid AND Permission=perm;", "GroupPermission")),
        PROCEDURE_CLEAR("GroupPermission_Clear", Database.getProcedureQuery("GroupPermission_Clear", "gid INT", "DELETE FROM %s WHERE GroupID=gid;", "GroupPermission")),
        PROCEDURE_EXPIRED("GroupPermission_Expired", Database.getProcedureQuery("GroupPermission_Expired", "gid INT, perm VARCHAR(1000), expired BIGINT(255)", "UPDATE %s SET ExpiredTime=expired WHERE GroupID=gid AND Permission=perm;", "GroupPermission"));

        private static final Procedure[] VALUES;
        private final String name;
        private final String query;

        private Procedure(String name, String query) {
            this.name = name;
            this.query = query;
        }

        public String getName() {
            return this.name;
        }

        public String getQuery() {
            return this.query;
        }

        public static void loadAll() {
            for (Procedure procedure : VALUES) {
                Database.update(procedure.getQuery(), new Object[0]);
            }
        }

        static {
            VALUES = Procedure.values();
        }
    }
}

