/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.murmelapi.group;

import de.murmelmeister.murmelapi.group.Group;
import de.murmelmeister.murmelapi.group.parent.GroupParent;
import de.murmelmeister.murmelapi.group.parent.GroupParentProvider;
import de.murmelmeister.murmelapi.group.permission.GroupPermission;
import de.murmelmeister.murmelapi.group.permission.GroupPermissionProvider;
import de.murmelmeister.murmelapi.group.settings.GroupColorSettings;
import de.murmelmeister.murmelapi.group.settings.GroupColorSettingsProvider;
import de.murmelmeister.murmelapi.group.settings.GroupSettings;
import de.murmelmeister.murmelapi.group.settings.GroupSettingsProvider;
import de.murmelmeister.murmelapi.utils.Database;
import java.util.List;

public final class GroupProvider
implements Group {
    private static final String TABLE_NAME = "Groups";
    private final GroupSettings settings;
    private final GroupColorSettings colorSettings;
    private final GroupParent parent;
    private final GroupPermission permission;

    public GroupProvider() {
        this.createTable();
        Procedure.loadAll();
        this.settings = new GroupSettingsProvider();
        this.colorSettings = new GroupColorSettingsProvider();
        this.parent = new GroupParentProvider();
        this.permission = new GroupPermissionProvider();
        this.createDefaultGroup();
    }

    private void createTable() {
        Database.update("CREATE TABLE IF NOT EXISTS %s (ID INT PRIMARY KEY AUTO_INCREMENT, GroupName VARCHAR(100))", TABLE_NAME);
    }

    @Override
    public boolean existsGroup(int id) {
        return Database.exists("CALL %s('%s')", Procedure.PROCEDURE_ID.getName(), id);
    }

    @Override
    public boolean existsGroup(String name) {
        return Database.exists("CALL %s('%s')", Procedure.PROCEDURE_NAME.getName(), name);
    }

    @Override
    public void createNewGroup(String name, int creatorId, int sortId, String teamId) {
        if (this.existsGroup(name)) {
            return;
        }
        Database.update("CALL %s('%s')", Procedure.PROCEDURE_INSERT.getName(), name);
        int id = this.getUniqueId(name);
        String team = teamId + this.getName(id);
        this.settings.createGroup(id, creatorId, sortId, team);
        this.colorSettings.createGroup(id, creatorId);
    }

    @Override
    public void deleteGroup(int id) {
        this.permission.clearPermission(id);
        this.parent.clearParent(id);
        this.colorSettings.deleteGroup(id);
        this.settings.deleteGroup(id);
        Database.update("CALL %s('%s')", Procedure.PROCEDURE_DELETE.getName(), id);
    }

    @Override
    public int getUniqueId(String name) {
        return Database.getInt(-1, "ID", "CALL %s('%s')", Procedure.PROCEDURE_NAME.getName(), name);
    }

    @Override
    public String getName(int id) {
        return Database.getString(null, "GroupName", "CALL %s('%s')", Procedure.PROCEDURE_ID.getName(), id);
    }

    @Override
    public void rename(int id, String newName) {
        Database.update("CALL %s('%s','%s')", Procedure.PROCEDURE_RENAME_BY_ID.getName(), id, newName);
    }

    @Override
    public void rename(String oldName, String newName) {
        Database.update("CALL %s('%s','%s')", Procedure.PROCEDURE_RENAME_BY_NAME.getName(), oldName, newName);
    }

    @Override
    public List<Integer> getUniqueIds() {
        return Database.getIntList("ID", "CALL %s", Procedure.PROCEDURE_ALL.getName());
    }

    @Override
    public List<String> getNames() {
        return Database.getStringList("GroupName", "CALL %s", Procedure.PROCEDURE_ALL.getName());
    }

    @Override
    public void loadExpired() {
        this.parent.loadExpired(this);
        this.permission.loadExpired(this);
    }

    private int createDefaultGroup() {
        int id = 1;
        if (this.existsGroup(id)) {
            return id;
        }
        String name = "default";
        Database.update("CALL %s('%s')", Procedure.PROCEDURE_INSERT.getName(), name);
        int creatorId = -1;
        String team = "9999" + this.getName(id);
        this.settings.createGroup(id, creatorId, 0, team);
        this.colorSettings.createGroup(id, creatorId, "<gray>", "", "", "", "", "<gray>", "", "", "7");
        return id;
    }

    @Override
    public int getDefaultGroup() {
        return this.createDefaultGroup();
    }

    @Override
    public GroupSettings getSettings() {
        return this.settings;
    }

    @Override
    public GroupColorSettings getColorSettings() {
        return this.colorSettings;
    }

    @Override
    public GroupParent getParent() {
        return this.parent;
    }

    @Override
    public GroupPermission getPermission() {
        return this.permission;
    }

    private static enum Procedure {
        PROCEDURE_ID("Groups_ID", Database.getProcedureQuery("Groups_ID", "gid INT", "SELECT * FROM %s WHERE ID=gid;", "Groups")),
        PROCEDURE_NAME("Groups_Name", Database.getProcedureQuery("Groups_Name", "gName VARCHAR(100)", "SELECT * FROM %s WHERE GroupName=gName;", "Groups")),
        PROCEDURE_INSERT("Groups_Insert", Database.getProcedureQuery("Groups_Insert", "gName VARCHAR(100)", "INSERT INTO %s (GroupName) VALUES (gName);", "Groups")),
        PROCEDURE_DELETE("Groups_Delete", Database.getProcedureQuery("Groups_Delete", "gid INT", "DELETE FROM %s WHERE ID=gid;", "Groups")),
        PROCEDURE_ALL("Groups_All", Database.getProcedureQuery("Groups_All", "", "SELECT * FROM %s;", "Groups")),
        PROCEDURE_RENAME_BY_ID("Groups_RenameByID", Database.getProcedureQuery("Groups_RenameByID", "gid INT, gName VARCHAR(100)", "UPDATE %s SET GroupName=gName WHERE ID=gid;", "Groups")),
        PROCEDURE_RENAME_BY_NAME("Groups_RenameByName", Database.getProcedureQuery("Groups_RenameByName", "oldGroup VARCHAR(100), newGroup VARCHAR(100)", "UPDATE %s SET GroupName=newGroup WHERE GroupName=oldGroup;", "Groups"));

        private static final Procedure[] VALUES;
        private final String name;
        private final String query;

        private Procedure(String name, String query) {
            this.name = name;
            this.query = query;
        }

        public String getName() {
            return this.name;
        }

        public String getQuery() {
            return this.query;
        }

        public static void loadAll() {
            for (Procedure procedure : VALUES) {
                Database.update(procedure.getQuery(), new Object[0]);
            }
        }

        static {
            VALUES = Procedure.values();
        }
    }
}

