/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.murmelapi.menu;

import de.murmelmeister.murmelapi.menu.Menu;
import de.murmelmeister.murmelapi.menu.button.Button;
import de.murmelmeister.murmelapi.menu.model.MenuClickLocation;
import java.util.Iterator;
import org.bukkit.GameMode;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public final class MenuListener
implements Listener {
    @EventHandler
    public void handleMenuClose(InventoryCloseEvent event) {
        HumanEntity humanEntity = event.getPlayer();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        Menu menu = Menu.getMenu(player);
        if (menu != null) {
            menu.handleMenuClean(event.getInventory());
        }
    }

    @EventHandler
    public void handleMenuClick(InventoryClickEvent event) {
        boolean clickAllowed;
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        Menu menu = Menu.getMenu(player);
        if (menu == null) {
            return;
        }
        int slot = event.getSlot();
        ItemStack slotItem = event.getCurrentItem();
        ItemStack cursor = event.getCursor();
        Inventory clickedInventory = event.getClickedInventory();
        ClickType clickType = event.getClick();
        InventoryAction action = event.getAction();
        MenuClickLocation whereClicked = clickedInventory != null ? (clickedInventory.getType() == InventoryType.CHEST ? MenuClickLocation.MENU : MenuClickLocation.PLAYER_INVENTORY) : MenuClickLocation.OUTSIDE;
        boolean allowed = menu.isActionAllowed(whereClicked, slot, slotItem, cursor, action);
        boolean bl = clickAllowed = (menu.isAllowShiftClick() || menu.isAllowShiftClick(slot)) && (clickType.isShiftClick() || clickType.isRightClick() || clickType.isLeftClick()) || action.toString().contains("PICKUP") || action.toString().contains("PLACE") || action.equals((Object)InventoryAction.SWAP_WITH_CURSOR);
        if (clickAllowed || action == InventoryAction.CLONE_STACK) {
            if (whereClicked == MenuClickLocation.MENU && slotItem != null) {
                Button button = menu.getButton(slot);
                if (button != null) {
                    menu.handleButtonClick(player, slot, action, clickType, button);
                } else {
                    menu.handleMenuClick(player, slot, action, clickType, cursor, slotItem, !allowed);
                }
            }
            if (!allowed) {
                event.setCancelled(true);
                player.updateInventory();
            }
        } else if (action == InventoryAction.MOVE_TO_OTHER_INVENTORY || whereClicked != MenuClickLocation.PLAYER_INVENTORY) {
            if (!allowed) {
                event.setCancelled(true);
                player.updateInventory();
            }
            if (player.getGameMode() == GameMode.CREATIVE && clickType.equals((Object)ClickType.SWAP_OFFHAND)) {
                player.getInventory().setItemInOffHand(null);
            }
        }
    }

    @EventHandler
    public void handleSwapItem(PlayerSwapHandItemsEvent event) {
        if (Menu.getMenu(event.getPlayer()) != null) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void handleInventoryDragTop(InventoryDragEvent event) {
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        Menu menu = Menu.getMenu(player);
        InventoryType type = event.getInventory().getType();
        if (menu != null && type == InventoryType.CHEST) {
            Inventory topInventory = event.getView().getTopInventory();
            int size = topInventory.getSize();
            Iterator iterator = event.getRawSlots().iterator();
            while (iterator.hasNext()) {
                ItemStack cursor;
                int slot = (Integer)iterator.next();
                if (slot > size) continue;
                ItemStack itemStack = cursor = event.getCursor() != null ? event.getCursor() : event.getOldCursor();
                if (menu.isActionAllowed(MenuClickLocation.MENU, slot, (ItemStack)event.getNewItems().get(slot), cursor, InventoryAction.PLACE_SOME)) continue;
                event.setCancelled(true);
                return;
            }
        }
    }
}

