/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.murmelapi.menu;

import de.murmelmeister.murmelapi.MurmelPlugin;
import de.murmelmeister.murmelapi.menu.button.BackButton;
import de.murmelmeister.murmelapi.menu.button.Button;
import de.murmelmeister.murmelapi.menu.button.InfoButton;
import de.murmelmeister.murmelapi.menu.event.MenuCloseEvent;
import de.murmelmeister.murmelapi.menu.event.MenuOpenEvent;
import de.murmelmeister.murmelapi.menu.model.InventoryDrawer;
import de.murmelmeister.murmelapi.menu.model.MenuClickLocation;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public abstract class Menu {
    private final Map<Integer, Button> buttons = new HashMap<Integer, Button>();
    private static final String TAG = MurmelPlugin.getInstance().getName();
    private static final String MENU_TAG_CURRENT = TAG + "_Menu";
    private static final String MENU_TAG_PREVIOUS = TAG + "_PreviousMenu";
    private static final String MENU_TAG_LAST_CLOSED = TAG + "_LastClosedMenu";
    private final Menu parent;
    private BackButton backButton = null;
    private String title = "<gray>Menu";
    private int size = 27;
    private Player viewer;
    private boolean slotNumberVisible = false;
    private boolean opened = false;
    private boolean allowShiftClick = false;
    private int infoSlot = -1;
    private Material placeholder = null;

    protected Menu() {
        this(null);
    }

    protected Menu(Menu parent) {
        this.parent = parent;
        if (parent != null) {
            this.setBackButton(this.getPositionBackButton(), parent);
        }
    }

    public void show(Player player) {
        this.show(player, this.title);
    }

    public void show(final Player player, String title) {
        this.viewer = player;
        final InventoryDrawer drawer = InventoryDrawer.of(this.size, title);
        this.drawMenu().forEach(drawer::setItem);
        this.handlePreDisplay(drawer);
        this.debugSlotNumber(drawer);
        Bukkit.getPluginManager().callEvent((Event)new MenuOpenEvent(this, drawer, player));
        Menu previousMenu = Menu.getMenu(player);
        if (previousMenu != null) {
            player.setMetadata(MENU_TAG_PREVIOUS, (MetadataValue)new FixedMetadataValue((Plugin)MurmelPlugin.getInstance(), (Object)previousMenu));
        }
        new BukkitRunnable(){

            public void run() {
                Menu.this.handleDisplay(drawer, player);
                player.setMetadata(MENU_TAG_CURRENT, (MetadataValue)new FixedMetadataValue((Plugin)MurmelPlugin.getInstance(), (Object)Menu.this));
                Menu.this.opened = true;
                Menu.this.handlePostDisplay(drawer);
            }
        }.runTaskLater((Plugin)MurmelPlugin.getInstance(), 1L);
    }

    private static Menu getMenu(Player player, String tag) {
        if (player.hasMetadata(tag)) {
            Menu menu = (Menu)((MetadataValue)player.getMetadata(tag).getFirst()).value();
            if (menu == null) {
                throw new NullPointerException("Menu missing from " + player.getName() + "'s metadata '" + tag + "' tag!");
            }
            return menu;
        }
        return null;
    }

    public static Menu getMenu(Player player) {
        return Menu.getMenu(player, MENU_TAG_CURRENT);
    }

    public static Menu getPreviousMenu(Player player) {
        return Menu.getMenu(player, MENU_TAG_PREVIOUS);
    }

    public static Menu getLastClosedMenu(Player player) {
        return Menu.getMenu(player, MENU_TAG_LAST_CLOSED);
    }

    public void registerButton(int slot, Button button) {
        this.buttons.put(slot, button);
    }

    protected Button getButton(int slot) {
        return this.buttons.get(slot);
    }

    protected void handlePreDisplay(InventoryDrawer drawer) {
    }

    protected void handleDisplay(InventoryDrawer drawer, Player player) {
        drawer.show(player);
    }

    protected void handlePostDisplay(Player player) {
    }

    protected void handlePostDisplay(InventoryDrawer drawer) {
    }

    public void restartMenu() {
        this.restartMenu(null);
    }

    public void restartMenu(String title) {
        this.restartMenu(title, true);
    }

    public void restartMenu(String title, boolean menuClose) {
        Player player = this.viewer;
        if (player == null) {
            throw new NullPointerException("Player is null");
        }
        Inventory inventory = player.getOpenInventory().getTopInventory();
        if (inventory.getType() != InventoryType.CHEST) {
            throw new NullPointerException(player.getName() + "'s inventory closed in the meanwhile (now == " + String.valueOf(inventory.getType()) + ").");
        }
        if (menuClose) {
            this.handleMenuClean(inventory);
        }
        this.handleRestart();
        ItemStack[] contents = inventory.getContents();
        Map<Integer, ItemStack> newContents = this.drawMenu();
        for (int i = 0; i < contents.length; ++i) {
            contents[i] = newContents.get(i);
        }
        inventory.setContents(contents);
        if (title != null) {
            this.show(player, title);
        } else {
            this.show(player);
        }
    }

    public void handleRestart() {
    }

    private Map<Integer, ItemStack> drawMenu() {
        HashMap<Integer, Button> drawButtons = new HashMap<Integer, Button>(this.buttons);
        this.buttons.clear();
        HashMap<Integer, ItemStack> items = new HashMap<Integer, ItemStack>();
        for (int slot = 0; slot < this.size; ++slot) {
            ItemStack item = this.getItemAt(slot);
            if (item != null && item.getType() == Material.AIR) {
                item = null;
            }
            items.put(slot, item);
        }
        for (Map.Entry entry : drawButtons.entrySet()) {
            int slot = (Integer)entry.getKey();
            Button button = (Button)entry.getValue();
            this.buttons.put(slot, button);
        }
        drawButtons.clear();
        if (this.getInfo() != null) {
            if (this.infoSlot == -1) {
                this.infoSlot = this.getDefaultInfoSlot();
            }
            Button infoButton = InfoButton.createInfoButton(this.getInfoSlot(), this.getInfo());
            items.put(infoButton.getSlot(), infoButton.getIcon());
        }
        if (this.backButton != null) {
            items.put(this.backButton.getSlot(), this.backButton.getIcon());
        }
        return items;
    }

    public ItemStack getItemAt(int slot) {
        if (this.backButton != null && slot == this.backButton.getSlot()) {
            return this.backButton.getIcon();
        }
        return this.buildMenuPanel();
    }

    private ItemStack buildMenuPanel() {
        if (this.placeholder == null) {
            return null;
        }
        ItemStack item = new ItemStack(this.placeholder);
        ItemMeta meta = item.getItemMeta();
        meta.displayName(MiniMessage.miniMessage().deserialize((Object)""));
        PersistentDataContainer container = meta.getPersistentDataContainer();
        container.set(new NamespacedKey((Plugin)JavaPlugin.getPlugin(MurmelPlugin.class), "menu"), PersistentDataType.BOOLEAN, (Object)true);
        item.setItemMeta(meta);
        return item;
    }

    public Menu getParent() {
        return this.parent;
    }

    public String getTitle() {
        return this.title;
    }

    protected void setTitle(String title) {
        this.title = title;
        if (this.viewer != null && this.opened) {
            this.viewer.updateInventory();
        }
    }

    public int getSize() {
        return this.size;
    }

    protected void setSize(int size) {
        this.size = size;
    }

    public Player getViewer() {
        return this.viewer;
    }

    protected void setViewer(Player viewer) {
        this.viewer = viewer;
    }

    protected final Inventory getInventory() {
        return this.viewer.getOpenInventory().getTopInventory();
    }

    protected final ItemStack[] getContents(int from, int to) {
        ItemStack[] contents = this.getInventory().getContents();
        ItemStack[] copy = new ItemStack[contents.length];
        for (int i = from; i < copy.length; ++i) {
            ItemStack item = contents[i];
            copy[i] = item != null ? item.clone() : null;
        }
        return Arrays.copyOfRange(copy, from, to);
    }

    protected void setItem(int slot, ItemStack item) {
        this.getInventory().setItem(slot, item);
    }

    private void debugSlotNumber(InventoryDrawer drawer) {
        if (this.slotNumberVisible) {
            for (int slot = 0; slot < drawer.getSize(); ++slot) {
                ItemStack item = drawer.getItem(slot);
                if (item != null) continue;
                ItemStack newItem = new ItemStack(Material.LIGHT_GRAY_STAINED_GLASS_PANE);
                ItemMeta meta = newItem.getItemMeta();
                meta.displayName(MiniMessage.miniMessage().deserialize((Object)("Slot " + slot)));
                newItem.setItemMeta(meta);
                drawer.setItem(slot, newItem);
            }
        }
    }

    protected void setSlotNumberVisible() {
        this.slotNumberVisible = true;
    }

    protected boolean isActionAllowed(MenuClickLocation location, int slot, ItemStack clicked, ItemStack cursor, InventoryAction action) {
        return this.isActionAllowed(location, slot, clicked, cursor);
    }

    protected boolean isActionAllowed(MenuClickLocation location, int slot, ItemStack clicked, ItemStack cursor) {
        return false;
    }

    protected boolean isAllowShiftClick() {
        return this.allowShiftClick;
    }

    protected boolean isAllowShiftClick(int slot) {
        return false;
    }

    protected void setAllowShiftClick(boolean allowShiftClick) {
        this.allowShiftClick = allowShiftClick;
    }

    public int getPositionBackButton() {
        return this.size - 1;
    }

    public int getDefaultInfoSlot() {
        return this.size - 9;
    }

    public int getInfoSlot() {
        return this.infoSlot;
    }

    public void setInfoSlot(int infoSlot) {
        this.infoSlot = infoSlot;
    }

    protected String[] getInfo() {
        return null;
    }

    protected void setBackButton(int slot, Menu parent) {
        this.backButton = new BackButton(slot, parent);
        this.buttons.put(slot, this.backButton);
    }

    public Material getPlaceholder() {
        return this.placeholder;
    }

    protected void setPlaceholder(Material placeholder) {
        this.placeholder = placeholder;
    }

    protected void handleMenuClick(Player player, int slot, InventoryAction action, ClickType clickType, ItemStack cursor, ItemStack clicked, boolean cancelled) {
        this.handleMenuClick(player, slot, clicked);
    }

    protected void handleMenuClick(Player player, int slot, ItemStack clicked) {
    }

    protected void handleButtonClick(Player player, int slot, InventoryAction action, ClickType clickType, Button button) {
        button.click(player, this, clickType);
    }

    protected void handleMenuClean(Inventory inventory) {
        this.viewer.removeMetadata(MENU_TAG_CURRENT, (Plugin)MurmelPlugin.getInstance());
        this.viewer.setMetadata(MENU_TAG_LAST_CLOSED, (MetadataValue)new FixedMetadataValue((Plugin)MurmelPlugin.getInstance(), (Object)this));
        this.opened = false;
        this.handleMenuClose(this.viewer, inventory);
        Bukkit.getPluginManager().callEvent((Event)new MenuCloseEvent(this, inventory, this.viewer));
    }

    protected void handleMenuClose(Player player, Inventory inventory) {
    }

    protected void animate(int periodTicks, MenuRunnable task) {
        this.wrapAnimation(task).runTaskTimer((Plugin)MurmelPlugin.getInstance(), 2L, (long)periodTicks);
    }

    protected void animateAsync(int periodTicks, MenuRunnable task) {
        this.wrapAnimation(task).runTaskTimerAsynchronously((Plugin)MurmelPlugin.getInstance(), 2L, (long)periodTicks);
    }

    private BukkitRunnable wrapAnimation(final MenuRunnable task) {
        return new BukkitRunnable(){
            boolean cancelled = false;

            public void run() {
                if (!Menu.this.opened) {
                    if (!this.cancelled) {
                        this.cancel();
                    }
                    return;
                }
                try {
                    task.run();
                }
                catch (RuntimeException e) {
                    this.cancelled = true;
                    this.cancel();
                }
            }
        };
    }

    @FunctionalInterface
    public static interface MenuRunnable
    extends Runnable {
        default public void cancel() {
            throw new RuntimeException();
        }
    }
}

