/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.murmelapi.group.permission;

import de.murmelmeister.murmelapi.MurmelAPI;
import de.murmelmeister.murmelapi.database.Database;
import de.murmelmeister.murmelapi.group.Group;
import de.murmelmeister.murmelapi.group.parent.GroupParent;
import de.murmelmeister.murmelapi.group.permission.GroupPermission;
import java.sql.Timestamp;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;

public final class GroupPermissionProvider
implements GroupPermission {
    private static final String TABLE_NAME = "GroupPermission";
    private final Database database;

    public GroupPermissionProvider(Database database) {
        this.database = database;
    }

    public static void setup(Database database) {
        database.createTable(TABLE_NAME, "GroupID INT, Permission VARCHAR(200), PRIMARY KEY (GroupID, Permission), FOREIGN KEY (GroupID) REFERENCES Groups(ID), ExpiredTime BIGINT, CreatedBy INT, FOREIGN KEY (CreatedBy) REFERENCES Users(ID), CreatedAt DATETIME DEFAULT CURRENT_TIMESTAMP(), ModifiedBy INT, FOREIGN KEY (ModifiedBy) REFERENCES Users(ID), ModifiedAt DATETIME DEFAULT CURRENT_TIMESTAMP() ON UPDATE CURRENT_TIMESTAMP()");
        Procedure.loadAll(database);
    }

    @Override
    public boolean existsPermission(int groupId, String permission) {
        return this.database.exists(Procedure.GET_ALL.getName(), groupId, permission);
    }

    @Override
    public void addPermission(int executorId, int groupId, String permission, long time) {
        long expired = time == -1L ? time : System.currentTimeMillis() + time;
        this.database.callUpdate(Procedure.CREATE.getName(), groupId, permission, expired, executorId, executorId);
    }

    @Override
    public void removePermission(int groupId, String permission) {
        this.database.callUpdate(Procedure.DELETE_PERMISSION.getName(), groupId, permission);
    }

    @Override
    public void clearPermission(int groupId) {
        this.database.callUpdate(Procedure.DELETE_GROUP.getName(), groupId);
    }

    @Override
    public List<String> getPermissions(int groupId) {
        return this.database.queryList(new LinkedList(), "Permission", String.class, Procedure.GET_BY_GROUP.getName(), groupId);
    }

    @Override
    public List<String> getAllPermissions(GroupParent groupParent, int groupId) {
        LinkedHashSet<String> permissions = new LinkedHashSet<String>();
        Stack<Integer> stack = new Stack<Integer>();
        stack.push(groupId);
        while (!stack.isEmpty()) {
            int currentGroupId = (Integer)stack.pop();
            permissions.addAll(this.getPermissions(currentGroupId));
            List<Integer> parentIds = groupParent.getParentIds(currentGroupId);
            for (int i = parentIds.size() - 1; i >= 0; --i) {
                stack.push(parentIds.get(i));
            }
        }
        return new LinkedList<String>(permissions);
    }

    @Override
    public long getExpiredTime(int groupId, String permission) {
        return this.database.query(-2L, "ExpiredTime", Long.TYPE, Procedure.GET_ALL.getName(), groupId, permission);
    }

    @Override
    public String getExpiredDate(int groupId, String permission) {
        long time = this.getExpiredTime(groupId, permission);
        return time == -1L ? "never" : MurmelAPI.getDateFormat().format(time);
    }

    @Override
    public String setExpiredTime(int executorId, int groupId, String permission, long time) {
        long expired = time == -1L ? time : System.currentTimeMillis() + time;
        this.database.callUpdate(Procedure.SET_EXPIRED_TIME.getName(), groupId, permission, expired, executorId);
        return this.getExpiredDate(groupId, permission);
    }

    @Override
    public boolean isExpired(int groupId, String permission) {
        return this.database.query((byte)0, "Expired", Byte.TYPE, Procedure.IS_EXPIRED.getName(), groupId, permission) == 1;
    }

    @Override
    public int getCreatedBy(int groupId, String permission) {
        return this.database.query(-2, "CreatedBy", Integer.TYPE, Procedure.GET_ALL.getName(), groupId, permission);
    }

    @Override
    public Timestamp getCreatedAt(int groupId, String permission) {
        return this.database.query(null, "CreatedAt", Timestamp.class, Procedure.GET_ALL.getName(), groupId, permission);
    }

    @Override
    public int getModifiedBy(int groupId, String permission) {
        return this.database.query(-2, "ModifiedBy", Integer.TYPE, Procedure.GET_ALL.getName(), groupId, permission);
    }

    @Override
    public Timestamp getModifiedAt(int groupId, String permission) {
        return this.database.query(null, "ModifiedAt", Timestamp.class, Procedure.GET_ALL.getName(), groupId, permission);
    }

    @Override
    public void loadExpired(Group group) {
        List<Integer> groupIds = group.getUniqueIds();
        for (int i = groupIds.size() - 1; i >= 0; --i) {
            int groupId = groupIds.get(i);
            List<String> permissions = this.getPermissions(groupId);
            for (int j = permissions.size() - 1; j >= 0; --j) {
                String permission = permissions.get(j);
                long time = this.getExpiredTime(groupId, permission);
                if (time == -1L || time > System.currentTimeMillis()) continue;
                this.removePermission(groupId, permission);
            }
        }
    }

    private static enum Procedure {
        CREATE("GroupPermission_Create", "gid INT, perm VARCHAR(200), et BIGINT, created INT, modified INT", "INSERT INTO [TABLE] (GroupID,Permission,ExpiredTime,CreatedBy,ModifiedBy) VALUES (gid,perm,et,created,modified);"),
        DELETE_PERMISSION("GroupPermission_DeletePermission", "gid INT, perm VARCHAR(200)", "DELETE FROM [TABLE] WHERE GroupID=gid AND Permission=perm;"),
        DELETE_GROUP("GroupPermission_DeleteGroup", "gid INT", "DELETE FROM [TABLE] WHERE GroupID=gid;"),
        GET_ALL("GroupPermission_GetAll", "gid INT, perm VARCHAR(200)", "SELECT * FROM [TABLE] WHERE GroupID=gid AND Permission=perm;"),
        GET_BY_GROUP("GroupPermission_GetByGroup", "gid INT", "SELECT Permission FROM [TABLE] WHERE GroupID=gid;"),
        SET_EXPIRED_TIME("GroupPermission_SetExpiredTime", "gid INT, perm VARCHAR(200), et BIGINT, modified INT", "UPDATE [TABLE] SET ExpiredTime=et, ModifiedBy=modified WHERE GroupID=gid AND Permission=perm;"),
        IS_EXPIRED("GroupPermission_IsExpired", "gid INT, perm VARCHAR(200)", "SELECT IF(ExpiredTime = -1, 0, ExpiredTime <= CURRENT_TIMESTAMP()) AS Expired FROM [TABLE] WHERE GroupID=gid AND Permission=perm;");

        private static final Procedure[] VALUES;
        private final String name;
        private final String query;

        private Procedure(String name, String input, String query) {
            this.name = name;
            this.query = Database.getProcedureQuery(name, input, query);
        }

        public String getName() {
            return this.name;
        }

        public String getQuery() {
            return this.query.replace("[TABLE]", GroupPermissionProvider.TABLE_NAME);
        }

        private static void loadAll(Database database) {
            for (Procedure procedure : VALUES) {
                database.update(procedure.getQuery(), new Object[0]);
            }
        }

        static {
            VALUES = Procedure.values();
        }
    }
}

