/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.murmelapi.configuration;

import de.murmelmeister.murmelapi.configuration.MurmelMemory;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.representer.Representer;

public class MurmelConfiguration
extends MurmelMemory {
    private final Yaml yaml;
    private final ReadWriteLock lock = new ReentrantReadWriteLock(true);
    private final Lock writeLock = this.lock.writeLock();

    public MurmelConfiguration() {
        DumperOptions dumperOptions = new DumperOptions();
        dumperOptions.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        dumperOptions.setPrettyFlow(true);
        LoaderOptions loaderOptions = new LoaderOptions();
        loaderOptions.setMaxAliasesForCollections(Integer.MAX_VALUE);
        loaderOptions.setCodePointLimit(Integer.MAX_VALUE);
        Representer representer = new Representer(dumperOptions);
        Constructor constructor = new Constructor(loaderOptions);
        this.yaml = new Yaml((BaseConstructor)constructor, representer, dumperOptions, loaderOptions);
    }

    public void load(File file) {
        this.writeLock.lock();
        try (FileReader reader = new FileReader(file);){
            Map loadedData = (Map)this.yaml.load(reader);
            this.data.clear();
            if (loadedData != null) {
                this.flattenData("", loadedData);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void save(File file) {
        this.writeLock.lock();
        try (FileWriter writer = new FileWriter(file);){
            Map<String, Object> nestedData = this.nestData(this.data);
            this.yaml.dump(nestedData, writer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public static MurmelConfiguration loadConfiguration(File file) {
        MurmelConfiguration config = new MurmelConfiguration();
        config.load(file);
        return config;
    }

    private void flattenData(String prefix, Map<String, Object> map) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key;
            String string = key = prefix.isEmpty() ? entry.getKey() : prefix + "." + entry.getKey();
            if (entry.getValue() instanceof Map) {
                this.flattenData(key, (Map)entry.getValue());
                continue;
            }
            this.data.put(key, entry.getValue());
        }
    }

    private Map<String, Object> nestData(Map<String, Object> flatData) {
        LinkedHashMap<String, Object> nestedData = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Object> entry : flatData.entrySet()) {
            String[] path = entry.getKey().split("\\.");
            Map<String, Object> currentMap = nestedData;
            for (int i = 0; i < path.length - 1; ++i) {
                currentMap = (Map)currentMap.computeIfAbsent(path[i], k -> new LinkedHashMap());
            }
            currentMap.put(path[path.length - 1], entry.getValue());
        }
        return nestedData;
    }
}

