/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.murmelapi;

import de.murmelmeister.murmelapi.database.Database;
import de.murmelmeister.murmelapi.group.Group;
import de.murmelmeister.murmelapi.group.GroupProvider;
import de.murmelmeister.murmelapi.group.color.GroupColorProvider;
import de.murmelmeister.murmelapi.group.parent.GroupParentProvider;
import de.murmelmeister.murmelapi.group.permission.GroupPermissionProvider;
import de.murmelmeister.murmelapi.logging.ActiveSession;
import de.murmelmeister.murmelapi.logging.ActiveSessionProvider;
import de.murmelmeister.murmelapi.logging.LoginHistory;
import de.murmelmeister.murmelapi.logging.LoginHistoryProvider;
import de.murmelmeister.murmelapi.permission.Permission;
import de.murmelmeister.murmelapi.permission.PermissionProvider;
import de.murmelmeister.murmelapi.punishment.PunishmentIP;
import de.murmelmeister.murmelapi.punishment.PunishmentIPProvider;
import de.murmelmeister.murmelapi.punishment.PunishmentType;
import de.murmelmeister.murmelapi.punishment.PunishmentUser;
import de.murmelmeister.murmelapi.punishment.PunishmentUserProvider;
import de.murmelmeister.murmelapi.punishment.log.PunishmentLog;
import de.murmelmeister.murmelapi.punishment.log.PunishmentLogProvider;
import de.murmelmeister.murmelapi.punishment.reason.PunishmentReason;
import de.murmelmeister.murmelapi.punishment.reason.PunishmentReasonProvider;
import de.murmelmeister.murmelapi.time.PlayTime;
import de.murmelmeister.murmelapi.time.PlayTimeProvider;
import de.murmelmeister.murmelapi.user.User;
import de.murmelmeister.murmelapi.user.UserProvider;
import de.murmelmeister.murmelapi.user.parent.UserParentProvider;
import de.murmelmeister.murmelapi.user.permission.UserPermissionProvider;
import java.text.SimpleDateFormat;
import java.util.UUID;

public final class MurmelAPI {
    private static String databaseName = "MurmelAPI";
    private static SimpleDateFormat dateFormat = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
    private static final Database DATABASE = new Database();
    private static LoginHistory loginHistory;
    private static ActiveSession activeSession;
    private static User user;
    private static Group group;
    private static PlayTime playTime;
    private static Permission permission;
    private static PunishmentReason punishmentReason;
    private static PunishmentLog punishmentLog;
    private static PunishmentIP punishmentIP;
    private static PunishmentUser punishmentUser;

    public static void connect(String url, String user, String password) {
        DATABASE.connect(url, user, password);
        MurmelAPI.setup();
    }

    public static void disconnect() {
        DATABASE.disconnect();
    }

    public static void setup() {
        UserProvider.setup(DATABASE);
        GroupProvider.setup(DATABASE);
        LoginHistoryProvider.setup(DATABASE);
        ActiveSessionProvider.setup(DATABASE);
        PlayTimeProvider.setup(DATABASE);
        GroupColorProvider.setup(DATABASE);
        GroupParentProvider.setup(DATABASE);
        GroupPermissionProvider.setup(DATABASE);
        UserParentProvider.setup(DATABASE);
        UserPermissionProvider.setup(DATABASE);
        PunishmentType.setup(DATABASE);
        PunishmentReasonProvider.setup(DATABASE);
        PunishmentLogProvider.setup(DATABASE);
        PunishmentIPProvider.setup(DATABASE);
        PunishmentUserProvider.setup(DATABASE);
        loginHistory = MurmelAPI.getLoginHistory();
        activeSession = MurmelAPI.getActiveSession();
        user = MurmelAPI.getUser();
        group = MurmelAPI.getGroup();
        playTime = MurmelAPI.getPlayTime();
        permission = MurmelAPI.getPermission(group, user);
        punishmentReason = MurmelAPI.getPunishmentReason();
        punishmentLog = MurmelAPI.getPunishmentLog(punishmentReason);
        punishmentIP = MurmelAPI.getPunishmentIP(punishmentReason, punishmentLog);
        punishmentUser = MurmelAPI.getPunishmentUser(punishmentReason, punishmentLog);
    }

    public static void deleteUser(int userId) {
        playTime.deleteUser(userId);
    }

    public static void deleteFullUser(int userId) {
        MurmelAPI.deleteUser(userId);
        UUID mojangId = user.getUniqueId(userId);
        user.deleteUser(mojangId);
    }

    public static String getDatabaseName() {
        return databaseName;
    }

    public static void setDatabaseName(String databaseName) {
        MurmelAPI.databaseName = databaseName;
    }

    public static SimpleDateFormat getDateFormat() {
        return dateFormat;
    }

    public static void setDateFormat(SimpleDateFormat dateFormat) {
        MurmelAPI.dateFormat = dateFormat;
    }

    public static Database getDatabase() {
        return DATABASE;
    }

    public static LoginHistory getLoginHistory() {
        if (loginHistory == null) {
            loginHistory = new LoginHistoryProvider(DATABASE);
        }
        return loginHistory;
    }

    public static ActiveSession getActiveSession() {
        if (activeSession == null) {
            activeSession = new ActiveSessionProvider(DATABASE);
        }
        return activeSession;
    }

    public static User getUser() {
        if (user == null) {
            user = new UserProvider(DATABASE);
        }
        return user;
    }

    public static Group getGroup() {
        if (group == null) {
            group = new GroupProvider(DATABASE);
        }
        return group;
    }

    public static PlayTime getPlayTime() {
        if (playTime == null) {
            playTime = new PlayTimeProvider(DATABASE);
        }
        return playTime;
    }

    public static Permission getPermission(Group group, User user) {
        if (permission == null) {
            permission = new PermissionProvider(group, user);
        }
        return permission;
    }

    public static Permission getPermission() {
        return MurmelAPI.getPermission(MurmelAPI.getGroup(), MurmelAPI.getUser());
    }

    public static PunishmentReason getPunishmentReason() {
        if (punishmentReason == null) {
            punishmentReason = new PunishmentReasonProvider(DATABASE);
        }
        return punishmentReason;
    }

    public static PunishmentLog getPunishmentLog(PunishmentReason reason) {
        if (punishmentLog == null) {
            punishmentLog = new PunishmentLogProvider(DATABASE, reason);
        }
        return punishmentLog;
    }

    public static PunishmentLog getPunishmentLog() {
        return MurmelAPI.getPunishmentLog(MurmelAPI.getPunishmentReason());
    }

    public static PunishmentIP getPunishmentIP(PunishmentReason reason, PunishmentLog log) {
        if (punishmentIP == null) {
            punishmentIP = new PunishmentIPProvider(DATABASE, reason, log);
        }
        return punishmentIP;
    }

    public static PunishmentIP getPunishmentIP() {
        return MurmelAPI.getPunishmentIP(MurmelAPI.getPunishmentReason(), MurmelAPI.getPunishmentLog());
    }

    public static PunishmentUser getPunishmentUser(PunishmentReason reason, PunishmentLog log) {
        if (punishmentUser == null) {
            punishmentUser = new PunishmentUserProvider(DATABASE, reason, log);
        }
        return punishmentUser;
    }

    public static PunishmentUser getPunishmentUser() {
        return MurmelAPI.getPunishmentUser(MurmelAPI.getPunishmentReason(), MurmelAPI.getPunishmentLog());
    }
}

