/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.murmelapi.time;

public enum PlayTimeType {
    SECONDS("Seconds", 1),
    MINUTES("Minutes", 60),
    HOURS("Hours", 3600),
    DAYS("Days", 86400),
    YEARS("Years", 31536000);

    private final String name;
    private final int multiplier;

    private PlayTimeType(String name, int multiplier) {
        this.name = name;
        this.multiplier = multiplier;
    }

    public String getName() {
        return this.name;
    }

    public int getMultiplier() {
        return this.multiplier;
    }

    public int toSeconds(int time) {
        return time * this.multiplier;
    }

    public int fromSeconds(int seconds) {
        return seconds / this.multiplier;
    }
}

