/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.murmelapi.group;

import de.murmelmeister.murmelapi.database.Database;
import de.murmelmeister.murmelapi.group.Group;
import de.murmelmeister.murmelapi.group.color.GroupColor;
import de.murmelmeister.murmelapi.group.color.GroupColorProvider;
import de.murmelmeister.murmelapi.group.parent.GroupParent;
import de.murmelmeister.murmelapi.group.parent.GroupParentProvider;
import de.murmelmeister.murmelapi.group.permission.GroupPermission;
import de.murmelmeister.murmelapi.group.permission.GroupPermissionProvider;
import de.murmelmeister.murmelapi.utils.CacheManager;
import java.sql.Timestamp;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public final class GroupProvider
implements Group {
    private static final String TABLE_NAME = "Groups";
    private final CacheManager<Integer, String> groupIdCache = new CacheManager();
    private final CacheManager<String, Integer> groupNameCache = new CacheManager();
    private final Database database;
    private GroupColor color;
    private GroupParent parent;
    private GroupPermission permission;

    public GroupProvider(Database database) {
        this.database = database;
        this.color = this.getColor();
        this.parent = this.getParent();
        this.permission = this.getPermission();
    }

    public static void setup(Database database) {
        database.createTable(TABLE_NAME, "ID INT PRIMARY KEY AUTO_INCREMENT, GroupName VARCHAR(100) UNIQUE, Priority INT, TeamSort VARCHAR(100), CreatedBy INT, FOREIGN KEY (CreatedBy) REFERENCES Users(ID), CreatedAt DATETIME DEFAULT CURRENT_TIMESTAMP(), ModifiedBy INT, FOREIGN KEY (ModifiedBy) REFERENCES Users(ID), ModifiedAt DATETIME DEFAULT CURRENT_TIMESTAMP() ON UPDATE CURRENT_TIMESTAMP()");
        Procedure.loadAll(database);
    }

    @Override
    public boolean existsGroup(int groupId) {
        return this.database.exists(Procedure.GROUPS_GET_ALL_BY_ID.getName(), groupId);
    }

    @Override
    public boolean existsGroup(String groupName) {
        return this.database.exists(Procedure.GROUPS_GET_ALL_BY_NAME.getName(), groupName);
    }

    @Override
    public void createNewGroup(String groupName, int createdBy, int priority, String teamId) {
        String team = teamId + groupName;
        this.database.callUpdate(Procedure.GROUPS_CREATE.getName(), groupName, priority, team, createdBy, createdBy);
        this.color.createGroup(createdBy, this.getUniqueId(groupName));
    }

    @Override
    public void deleteGroup(int executorId, int groupId) {
        String groupName = this.getName(groupId);
        this.database.callUpdate(Procedure.GROUPS_DELETE.getName(), groupId);
        if (groupName != null) {
            this.groupNameCache.remove(groupName);
        }
        if (this.groupIdCache.get(groupId) != null) {
            this.groupIdCache.remove(groupId);
        }
    }

    @Override
    public int getUniqueId(String groupName) {
        Integer groupId = this.groupNameCache.get(groupName);
        if (groupId == null) {
            groupId = this.loadIdByGroupName(groupName);
            this.groupNameCache.put(groupName, groupId, 1L, TimeUnit.HOURS);
        }
        return groupId;
    }

    private int loadIdByGroupName(String groupName) {
        return this.database.query(-1, "ID", Integer.TYPE, Procedure.GROUPS_GET_ALL_BY_NAME.getName(), groupName);
    }

    @Override
    public String getName(int groupId) {
        String groupName = this.groupIdCache.get(groupId);
        if (groupName == null) {
            groupName = this.loadNameById(groupId);
            this.groupIdCache.put(groupId, groupName, 1L, TimeUnit.HOURS);
        }
        return groupName;
    }

    private String loadNameById(int groupId) {
        return this.database.query(null, "GroupName", String.class, Procedure.GROUPS_GET_ALL_BY_ID.getName(), groupId);
    }

    @Override
    public void rename(int executorId, int groupId, String newName) {
        this.database.callUpdate(Procedure.GROUPS_SET_GROUP_NAME.getName(), newName, groupId, executorId);
    }

    @Override
    public List<Integer> getUniqueIds() {
        return this.database.queryList(new LinkedList(), "ID", Integer.TYPE, Procedure.GROUPS_GET_ALL.getName(), new Object[0]);
    }

    @Override
    public List<String> getNames() {
        return this.database.queryList(new LinkedList(), "GroupName", String.class, Procedure.GROUPS_GET_ALL.getName(), new Object[0]);
    }

    @Override
    public int getPriority(int groupId) {
        return this.database.query(-1, "Priority", Integer.TYPE, Procedure.GROUPS_GET_ALL_BY_ID.getName(), groupId);
    }

    @Override
    public void setPriority(int executorId, int groupId, int priority) {
        this.database.callUpdate(Procedure.GROUPS_SET_PRIORITY.getName(), priority, groupId, executorId);
    }

    @Override
    public String getTeamSort(int groupId) {
        return this.database.query(null, "TeamSort", String.class, Procedure.GROUPS_GET_ALL_BY_ID.getName(), groupId);
    }

    @Override
    public void setTeamSort(int executorId, int groupId, String teamSort) {
        this.database.callUpdate(Procedure.GROUPS_SET_TEAM_SORT.getName(), teamSort, groupId, executorId);
    }

    @Override
    public int getCreatedBy(int groupId) {
        return this.database.query(-2, "CreatedBy", Integer.TYPE, Procedure.GROUPS_GET_ALL_BY_ID.getName(), groupId);
    }

    @Override
    public Timestamp getCreatedAt(int groupId) {
        return this.database.query(null, "CreatedAt", Timestamp.class, Procedure.GROUPS_GET_ALL_BY_ID.getName(), groupId);
    }

    @Override
    public int getModifiedBy(int groupId) {
        return this.database.query(-2, "ModifiedBy", Integer.TYPE, Procedure.GROUPS_GET_ALL_BY_ID.getName(), groupId);
    }

    @Override
    public Timestamp getModifiedAt(int groupId) {
        return this.database.query(null, "ModifiedAt", Timestamp.class, Procedure.GROUPS_GET_ALL_BY_ID.getName(), groupId);
    }

    @Override
    public void createDefaultGroup(String groupName) {
        if (this.existsGroup(groupName)) {
            return;
        }
        int createdBy = -1;
        int priority = 1;
        String teamId = "9999" + groupName;
        this.database.callUpdate(Procedure.GROUPS_CREATE.getName(), groupName, priority, teamId, createdBy, createdBy);
        int id = this.getUniqueId(groupName);
        this.color.createGroup(createdBy, id, "<gray>", "", "", "", "", "<gray>", "", "", "7");
    }

    @Override
    public void loadExpired() {
        this.parent.loadExpired(this);
        this.permission.loadExpired(this);
    }

    @Override
    public GroupColor getColor() {
        if (this.color == null) {
            this.color = new GroupColorProvider(this.database);
        }
        return this.color;
    }

    @Override
    public GroupParent getParent() {
        if (this.parent == null) {
            this.parent = new GroupParentProvider(this.database);
        }
        return this.parent;
    }

    @Override
    public GroupPermission getPermission() {
        if (this.permission == null) {
            this.permission = new GroupPermissionProvider(this.database);
        }
        return this.permission;
    }

    private static enum Procedure {
        GROUPS_GET_ALL_BY_ID("Groups_GetAllById", "gid INT", "SELECT * FROM [TABLE] WHERE ID=gid;"),
        GROUPS_GET_ALL_BY_NAME("Groups_GetAllByName", "gname VARCHAR(100)", "SELECT ID FROM [TABLE] WHERE GroupName=gname;"),
        GROUPS_GET_ALL("Groups_GetAll", "", "SELECT * FROM [TABLE];"),
        GROUPS_CREATE("Groups_Create", "gname VARCHAR(100), prio INT, tsort VARCHAR(100), created INT, modified INT", "INSERT INTO [TABLE] (GroupName,Priority,TeamSort,CreatedBy,ModifiedBy) VALUES (gname,prio,tsort,created,modified);"),
        GROUPS_DELETE("Groups_Delete", "gid INT", "DELETE FROM [TABLE] WHERE ID=gid;"),
        GROUPS_SET_PRIORITY("Groups_SetPriority", "prio INT, gid INT, modified INT", "UPDATE [TABLE] SET Priority=prio, ModifiedBy=modified WHERE ID=gid;"),
        GROUPS_SET_TEAM_SORT("Groups_SetTeamSort", "tsort VARCHAR(100), gid INT, modified INT", "UPDATE [TABLE] SET TeamSort=tsort, ModifiedBy=modified WHERE ID=gid;"),
        GROUPS_SET_GROUP_NAME("Groups_SetGroupName", "gname VARCHAR(100), gid INT, modified INT", "UPDATE [TABLE] SET GroupName=gname, ModifiedBy=modified WHERE ID=gid;");

        private static final Procedure[] VALUES;
        private final String name;
        private final String query;

        private Procedure(String name, String input, String query) {
            this.name = name;
            this.query = Database.getProcedureQuery(name, input, query);
        }

        public String getName() {
            return this.name;
        }

        public String getQuery() {
            return this.query.replace("[TABLE]", GroupProvider.TABLE_NAME);
        }

        private static void loadAll(Database database) {
            for (Procedure procedure : VALUES) {
                database.update(procedure.getQuery(), new Object[0]);
            }
        }

        static {
            VALUES = Procedure.values();
        }
    }
}

