/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.library.configuration;

import de.murmelmeister.library.exceptions.YamlMurmelException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.comments.CommentLine;
import org.yaml.snakeyaml.comments.CommentType;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.representer.Representer;

public class YamlMurmel {
    private final Path path;
    private final Yaml yaml;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();

    public YamlMurmel(Builder builder) {
        this.path = Path.of(builder.fileName, new String[0]);
        DumperOptions dumperOptions = new DumperOptions();
        dumperOptions.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        dumperOptions.setIndent(builder.indent);
        dumperOptions.setPrettyFlow(builder.prettyFlow);
        dumperOptions.setWidth(builder.width);
        dumperOptions.setProcessComments(builder.processComments);
        LoaderOptions loaderOptions = new LoaderOptions();
        loaderOptions.setAllowDuplicateKeys(builder.allowDuplicateKeys);
        loaderOptions.setMaxAliasesForCollections(builder.maxAliasesForCollections);
        loaderOptions.setWrappedToRootException(builder.wrappedToRootException);
        loaderOptions.setProcessComments(builder.processComments);
        SafeConstructor safeConstructor = new SafeConstructor(loaderOptions);
        Representer representer = new Representer(dumperOptions);
        this.yaml = new Yaml((BaseConstructor)safeConstructor, representer, dumperOptions, loaderOptions);
    }

    /*
     * Exception decompiling
     */
    public <T> T getValue(String key, Class<T> type) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [17[FORLOOP]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public <T> T getValue(String key, Class<T> type, T fallback) {
        T value = this.getValue(key, type);
        if (value != null) {
            return value;
        }
        this.setValue(key, fallback);
        return fallback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void setValue(String key, T value) {
        this.lock.writeLock().lock();
        try {
            LinkedHashMap root;
            block18: {
                if (Files.exists(this.path, new LinkOption[0])) {
                    try (InputStream inputStream = Files.newInputStream(this.path, new OpenOption[0]);){
                        root = new LinkedHashMap((Map)this.yaml.load(inputStream));
                        break block18;
                    }
                    catch (IOException e) {
                        throw new YamlMurmelException("Error reading file: " + String.valueOf(this.path), e);
                    }
                }
                root = new LinkedHashMap();
            }
            String[] keys = key.split("\\.");
            LinkedHashMap current = root;
            for (int i = 0; i < keys.length - 1; ++i) {
                String part = keys[i];
                Object next = current.get(part);
                if (next instanceof Map) {
                    Map rawNext = (Map)next;
                    LinkedHashMap nextMap = new LinkedHashMap();
                    for (Map.Entry entry : rawNext.entrySet()) {
                        nextMap.put(entry.getKey().toString(), entry.getValue());
                    }
                    current.put(part, nextMap);
                    current = nextMap;
                    continue;
                }
                LinkedHashMap newMap = new LinkedHashMap();
                current.put(part, newMap);
                current = newMap;
            }
            current.put(keys[keys.length - 1], value);
            try {
                if (this.path.getParent() != null) {
                    Files.createDirectories(this.path.getParent(), new FileAttribute[0]);
                }
                Files.writeString(this.path, (CharSequence)this.yaml.dump(root), new OpenOption[0]);
            }
            catch (IOException e) {
                throw new YamlMurmelException("Error writing to file: " + String.valueOf(this.path), e);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeKey(String key) {
        block21: {
            this.lock.writeLock().lock();
            try {
                Map removed;
                LinkedHashMap root;
                block20: {
                    if (Files.exists(this.path, new LinkOption[0])) {
                        try (InputStream inputStream = Files.newInputStream(this.path, new OpenOption[0]);){
                            root = new LinkedHashMap((Map)this.yaml.load(inputStream));
                            break block20;
                        }
                        catch (IOException e) {
                            throw new YamlMurmelException("Error reading file: " + String.valueOf(this.path), e);
                        }
                    }
                    return;
                }
                String[] keys = key.split("\\.");
                int depth = keys.length;
                LinkedList<Object> nodeStack = new LinkedList<Object>(Collections.nCopies(depth, null));
                ArrayList<Object> keyStack = new ArrayList<Object>(Collections.nCopies(depth, null));
                LinkedHashMap current = root;
                for (int i = 0; i < depth - 1; ++i) {
                    String part = keys[i];
                    Object next = current.get(part);
                    if (!(next instanceof Map)) {
                        return;
                    }
                    Map rawNext = (Map)next;
                    LinkedHashMap nextMap = new LinkedHashMap();
                    for (Map.Entry entry : rawNext.entrySet()) {
                        nextMap.put(entry.getKey().toString(), entry.getValue());
                    }
                    nodeStack.set(i, current);
                    keyStack.set(i, part);
                    current.put(part, nextMap);
                    current = nextMap;
                }
                nodeStack.set(depth - 1, current);
                keyStack.set(depth - 1, keys[keys.length - 1]);
                String lastKey = keys[depth - 1];
                if (!current.containsKey(lastKey)) break block21;
                current.remove(lastKey);
                for (int i = depth - 1; i > 0 && (removed = (Map)nodeStack.get(i)).isEmpty(); --i) {
                    Map parent = (Map)nodeStack.get(i - 1);
                    String keyToRemove = (String)keyStack.get(i - 1);
                    parent.remove(keyToRemove);
                }
                try {
                    Files.writeString(this.path, (CharSequence)this.yaml.dump(root), new OpenOption[0]);
                }
                catch (IOException e) {
                    throw new YamlMurmelException("Error writing to file: " + String.valueOf(this.path), e);
                }
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addComment(String key, String comment, boolean inLine) {
        this.lock.writeLock().lock();
        try {
            Node rootNode;
            block22: {
                if (Files.exists(this.path, new LinkOption[0])) {
                    try (BufferedReader reader = Files.newBufferedReader(this.path);){
                        rootNode = this.yaml.compose((Reader)reader);
                        break block22;
                    }
                    catch (IOException e) {
                        throw new YamlMurmelException("Error reading file: " + String.valueOf(this.path), e);
                    }
                }
                return;
            }
            if (!(rootNode instanceof MappingNode)) {
                return;
            }
            String[] keys = key.split("\\.");
            NodeTuple tuple = this.findNodeTuple(rootNode, keys);
            if (tuple == null) {
                return;
            }
            if (inLine) {
                this.setCommentInLine(tuple.getValueNode(), comment);
            } else {
                this.setCommentBlock(tuple.getKeyNode(), comment);
            }
            try {
                if (this.path.getParent() != null) {
                    Files.createDirectories(this.path.getParent(), new FileAttribute[0]);
                }
                StringWriter writer = new StringWriter();
                this.yaml.serialize(rootNode, (Writer)writer);
                Files.writeString(this.path, (CharSequence)writer.toString(), new OpenOption[0]);
            }
            catch (IOException e) {
                throw new YamlMurmelException("Error writing to file: " + String.valueOf(this.path), e);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private void setCommentInLine(Node node, String comment) {
        CommentLine line = new CommentLine(null, null, " " + comment, CommentType.IN_LINE);
        List comments = node.getInLineComments();
        comments.add(line);
        node.setInLineComments(comments);
    }

    private void setCommentBlock(Node node, String comment) {
        CommentLine line = new CommentLine(null, null, " " + comment, CommentType.BLOCK);
        List comments = node.getBlockComments();
        comments.add(line);
        node.setBlockComments(comments);
    }

    private NodeTuple findNodeTuple(Node root, String[] path) {
        if (!(root instanceof MappingNode)) {
            return null;
        }
        MappingNode mappingNode = (MappingNode)root;
        String currentKey = path[0];
        for (NodeTuple tuple : mappingNode.getValue()) {
            ScalarNode scalarNode;
            Node keyNode = tuple.getKeyNode();
            Node valueNode = tuple.getValueNode();
            if (!(keyNode instanceof ScalarNode) || !(scalarNode = (ScalarNode)keyNode).getValue().equals(currentKey)) continue;
            if (path.length == 1) {
                return tuple;
            }
            String[] remainingPath = Arrays.copyOfRange(path, 1, path.length);
            return this.findNodeTuple(valueNode, remainingPath);
        }
        return null;
    }

    public static Builder builder(String fileName) {
        return new Builder(fileName);
    }

    public static final class Builder {
        private final String fileName;
        private int indent = 2;
        private boolean prettyFlow = true;
        private int width = 80;
        private boolean processComments = true;
        private boolean allowDuplicateKeys = false;
        private int maxAliasesForCollections = 100;
        private boolean wrappedToRootException = true;

        private Builder(String fileName) {
            this.fileName = fileName;
        }

        public Builder indent(int indent) {
            this.indent = indent;
            return this;
        }

        public Builder prettyFlow(boolean prettyFlow) {
            this.prettyFlow = prettyFlow;
            return this;
        }

        public Builder width(int width) {
            this.width = width;
            return this;
        }

        public Builder processComments(boolean processComments) {
            this.processComments = processComments;
            return this;
        }

        public Builder allowDuplicateKeys(boolean allowDuplicateKeys) {
            this.allowDuplicateKeys = allowDuplicateKeys;
            return this;
        }

        public Builder maxAliasesForCollections(int maxAliasesForCollections) {
            this.maxAliasesForCollections = maxAliasesForCollections;
            return this;
        }

        public Builder wrappedToRootException(boolean wrappedToRootException) {
            this.wrappedToRootException = wrappedToRootException;
            return this;
        }

        public YamlMurmel build() {
            return new YamlMurmel(this);
        }
    }
}

